local BC = rawget(_G, "EURY_COOKINGUI") or {}
_G.EURY_COOKINGUI = BC

-- GLOBAL seasoning suffix shared by all modules
BC.SPICE_SUFFIX = getText("ContextMenu_EvolvedRecipe_Spice") or " as Seasoning"

local DEBUG = getCore():getDebug() or isAdmin()

---------------------------------------------------------------------------
-- Helpers
---------------------------------------------------------------------------

function BC.log(message)
    if DEBUG then
        DebugLog.log(DebugType.General, "[BC] " .. message)
    end
end

---Return a "time until spoilage" value for sorting.
---Non-perishables get a large value so they sink to the bottom.
---@param evoItem InventoryItem
---@return number
function BC.getTimeLeft(evoItem) -- getSeasoningTimeLeft
    local HUGE = 1e9

    if not evoItem or not instanceof(evoItem, "Food") then
        return HUGE
    end

    local offAge = evoItem:getOffAge()
    local age    = evoItem:getAge()
    if not offAge or not age then
        return HUGE
    end

    local timeLeft = offAge - age
    if timeLeft < 0 then
        timeLeft = 0
    end
    return timeLeft
end

function BC.isSeasoning(evoItem)
    if not evoItem then
        return false
    end

    -- 42.13: For Food instances, the per-item Food:isSpice() is the authoritative spice flag.
    if instanceof(evoItem, "Food") then
        return evoItem.isSpice and evoItem:isSpice() or false
    end

    -- Fallback: non-Food spice carriers can still be flagged at the script-item level.
    local script = evoItem.getScriptItem and evoItem:getScriptItem() or nil
    if script and script.isSpice and script:isSpice() then
        return true
    end

    return false
end

---Return "uses left" for sorting drainable seasonings.
---Lower usesLeft = should be used up sooner.
---@param evoItem InventoryItem
---@return number
function BC.getUsesLeft(evoItem) -- getSeasoningUsesLeft
    local HUGE = 1e9

    if not evoItem then
        return HUGE
    end

    -- Drainable condiments (ketchup, mustard, etc.)
    if evoItem.isDrainable and evoItem:isDrainable() then
        -- getDrainableUsesInt() returns whole uses left for drainables.
        local usesInt = evoItem.getDrainableUsesInt and evoItem:getDrainableUsesInt()
        if usesInt ~= nil then
            -- 0 or low values = almost empty → we want them first
            return usesInt
        end
    end

    -- Non-drainables / unknowns get a big value so they come after
    -- real "almost empty" condiments when spoilage is equal.
    return HUGE
end

---Heuristic: is this option an "Add Random ..." style entry?
---We keep these at the very top of the main evo submenu.
---@param name string
---@return boolean
function BC.isRandomEvoOptionName(name)
    if not name then return false end
    local lowerName = string.lower(name)
    if string.find(lowerName, "random", 1, true) then
        return true
    end
    -- If there is ever a dedicated translation key for "Random" we can add it here.
    return false
end
